unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, DBTables, ExtCtrls, Grids, DBGrids, Menus, DBCtrls, Mask, Db,
  RefInt;

type
  TForm1 = class(TForm)
    MainMenu1: TMainMenu;
    Quit1: TMenuItem;
    Panel4: TPanel;
    Splitter2: TSplitter;
    Panel3: TPanel;
    Splitter1: TSplitter;
    DBGTables: TDBGrid;
    DBGFields: TDBGrid;
    Panel5: TPanel;
    DBGParentTables: TDBGrid;
    Splitter3: TSplitter;
    DBGParentFields: TDBGrid;
    Clear1: TMenuItem;
    Panel1: TPanel;
    Button1: TButton;
    Button2: TButton;
    Button3: TButton;
    Button4: TButton;
    Panel2: TPanel;
    CBDatabases: TComboBox;
    Label1: TLabel;
    RefInt1: TRefInt;
    procedure FormCreate(Sender: TObject);
    procedure CBDatabasesChange(Sender: TObject);
    procedure Splitter1Moved(Sender: TObject);
    procedure Splitter3Moved(Sender: TObject);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
    procedure Quit1Click(Sender: TObject);
    procedure Clear1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure Button4Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
  private
  public
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.FormCreate(Sender: TObject);
begin
  Session.getDatabaseNames(CBDatabases.items);
  if RefInt1.Active then
    CBDatabases.ItemIndex:=CBDatabases.Items.IndexOf(RefInt1.AliasName);
end;

procedure TForm1.CBDatabasesChange(Sender: TObject);
begin
  RefInt1.AliasName:=(Sender as TComboBox).text;
  Button1.enabled:=True;
  Button2.enabled:=True;
  Button3.enabled:=True;
  Button4.enabled:=True;
end;

procedure TForm1.Splitter1Moved(Sender: TObject);
begin
  DBGParentTables.Width:=DBGTables.Width;
end;

procedure TForm1.Splitter3Moved(Sender: TObject);
begin
  DBGTables.Width:=DBGParentTables.Width;
end;

procedure TForm1.FormCloseQuery(Sender: TObject; var CanClose: Boolean);
begin
  if RefInt1.Changed then
  if messageDlg('Do you want to save your changes on database '+RefInt1.AliasName+' before closing ?',mtConfirmation,[mbYes,mbNo],0)=mrYes then
    RefInt1.WriteToDatabase;
end;

procedure TForm1.Quit1Click(Sender: TObject);
begin
  close;
end;

procedure TForm1.Clear1Click(Sender: TObject);
begin
  RefInt1.ClearAll;
end;

procedure TForm1.Button2Click(Sender: TObject);
begin
  RefInt1.WriteToFile;
end;

procedure TForm1.Button1Click(Sender: TObject);
begin
  RefInt1.ReadFromFile;
end;

procedure TForm1.Button4Click(Sender: TObject);
begin
  if RefInt1.Changed then
    RefInt1.WriteToDatabase
  else
    ShowMessage('Nothing to do !');
end;

procedure TForm1.Button3Click(Sender: TObject);
begin
  RefInt1.ReadFromDatabase;
end;

end.
